function x = PolovljenjeIntervala(f, a, b, epsilon)

if feval(f, a) == 0
    x = a;
    return
elseif feval(f, b) == 0
    x = b;
    return
elseif feval(f, a) * feval(f, b) > 0
    error 'Nije moguce upotrebiti metodu polovljenja intervala'
end

A(1) = a;
B(1) = b;
n = round(feval('log', (b-a)/epsilon)/feval('log', 2));

for i = 2 : n+1
    s = (A(i-1)+B(i-1))/2;
    if feval(f, s) == 0
        x = s;
        return
    elseif feval(f, A(i-1))*feval(f, s) < 0
        A(i) = A(i-1);
        B(i) = s;
    else
        A(i) = s;
        B(i) = B(i-1);
    end
end

x = (A(n+1)+B(n+1))/2;